<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Instractors extends Model 
{

    protected $table = 'instractors';
    public $timestamps = true;
    protected $fillable = array('student_id');

    public function student()
    {
        return $this->belongsTo('App\Models\Student');
    }

    public function courses()
    {
        return $this->hasMany('App\Models\Course');
    }

    public function reports()
    {
        return $this->morphToMany('App\Models\Student', 'reportable');
    }

}